#pragma rtGlobals=1		// Use modern global access method.

#pragma rtGlobals=1		// Use modern global access method.
Menu "Plot&fit"
Submenu "Plotting Utilities"
	"-"
	"Digitize",NewTraceWindow()
	end
end

Macro NewTraceWindow()
	Make/O dummyY={0,NaN,1}
	Display/L=LDummy/B=BDummy dummyY
	PauseUpdate; Silent 1
	ModifyGraph margin=1
	ModifyGraph nticks=0,axThick=0
	ModifyGraph freePos=150
	SetDrawLayer UserBack
	ControlBar 38
	Button b1,pos={8,9},size={67,20},proc=BPNewAxis,title="New Axis"
	Button b2,pos={85,9},size={77,20},proc=BPNewTrace,title="New trace"
	Button b3,pos={172,9},size={98,20},proc=ExitButtonProc,title="Exit Edit Mode"
	Button b4 proc=CleanupButtonProc,title="DONE"
End

Proc SetPlotRect() : GraphMarquee
	Silent 1
	GetMarquee/K
	Variable vl=V_left,vt=V_top,vr=V_right,vb=V_Bottom
	GetWindow kwTopWin,gsize
	ModifyGraph margin(left)=vl-V_left,margin(top)=vt-V_top,margin(right)=V_right-vr,margin(bottom)=V_bottom-vb
end

Proc AddNewAxis(axType,axName,axMin,axMax)
	Variable axType=1,axMin=0,axMax=1
	String axName=""
	Prompt axType,"Axis type:",popup, "Left;Bottom;Right;Top"
	Prompt axName,"Name of new axis"
	Prompt axMin,"Axis min value"
	Prompt axMax,"Axis max value"
	
	String cmd
	if( strlen(axName) == 0 )
		axName= "top"
		if( axType==1 )
			axName= "left"
		endif
		if( axType==2 )
			axName= "bottom"
		endif
		if( axType==3 )
			axName=="right"
		endif
	endif
	sprintf cmd,"AppendToGraph/%s=%s","LBRT"[axType-1],axName
	if( (axType==1) %| (axType==3) )
		cmd += "/B=BDummy"
	else
		cmd += "/L=LDummy"
	endif
	Execute cmd+" dummyY"
	SetAxis $axName,axMin,axMax
end

Proc SetAxisRange(axName,axMin,axMax) : GraphMarquee 
	String axName
	Variable axMin,axMax
	Prompt axName,"Axis:",popup, AxisList("")
	Prompt axMin,"Axis min value"
	Prompt axMax,"Axis max value"
	
	Silent 1
	GetMarquee/K
	Variable vl=V_left,vt=V_top,vr=V_right,vb=V_Bottom
	GetWindow kwTopWin,psize
	String s= AxisInfo("",axName)
	Variable p2,p1= StrSearch(s,"AXTYPE:",0)
	p1+=strlen("AXTYPE:")
	p2= StrSearch(s,";",p1)
	String axType= s[p1,p2-1]
	Variable raxMin,raxMax
	if( (CmpStr(axType,"left")==0) %|  (CmpStr(axType,"right")==0) )
		raxMin= ((axMax-axMin)/(vt-vb))*(V_Bottom-vb)+axMin
		raxMax= ((axMax-axMin)/(vt-vb))*(V_Top-vb)+axMin
	else
		raxMin= ((axMax-axMin)/(vr-vl))*(V_Left-vl)+axMin
		raxMax= ((axMax-axMin)/(vr-vl))*(V_Right-vl)+axMin
	endif
	SetAxis $axName,raxMin,raxMax
end

Proc AddNewTrace(yaxis,xaxis,yname,xname)
	String yaxis="left",xaxis="bottom",yname="waveY",xname="waveX"
	Prompt yaxis,"Y Axis Name:",popup,AxisList("")
	Prompt xaxis,"X Axis Name:",popup,AxisList("")
	Prompt yname,"Name for new Y wave"
	Prompt xname,"Name for new X wave"
	
	Silent 1
	String s= AxisInfo("",yaxis)
	Variable p2,p1= StrSearch(s,"AXTYPE:",0)
	p1+=strlen("AXTYPE:")
	String yaxType= s[p1]

	s= AxisInfo("",xaxis)
	p1= StrSearch(s,"AXTYPE:",0)
	p1+=strlen("AXTYPE:")
	String xaxType= s[p1]
	
	String cmd
	sprintf cmd,"GraphWaveDraw/%s=%s/%s=%s %s,%s",yaxType,yaxis,xaxType,xaxis,yname,xname
	Execute cmd
End

Proc BPNewAxis(ctrlName) : ButtonControl
	String ctrlName

	AddNewAxis()
End

Proc BPNewTrace(ctrlName) : ButtonControl
	String ctrlName

	AddNewTrace()
End

Proc ExitButtonProc(ctrlName) : ButtonControl
	String ctrlName

	GraphNormal
End

Proc CleanupButtonProc(ctrlName) : ButtonControl
	String ctrlName

	PauseUpdate; Silent 1
	GraphNormal
	ControlBar 0
	HideTools
	KillControl b1
	KillControl b2
	KillControl b3
	KillControl b4
	SetDrawLayer/K UserBack
	SetDrawLayer UserFront
	do
		CheckDisplayed dummyY
		if( V_Flag )
			RemoveFromGraph dummyY
		else
			break
		endif
	while(1)
	KillWaves dummyY
End
